#include <stdlib.h>
#include <stdio.h>
#include "fc-client.h"

int main(int argc, char** argv)
{
    FreecraftData* data;
    int numUnits[NUM_UNITS] = {0};
    int useAction[NUM_ACTIONS] = {0};
    int i, j, port, kill;

    if (argc > 1)
	port = atoi(argv[1]);
    else
	port = DEF_PORT;

    if (argc > 2)
	numUnits[Peasant] = atoi(argv[2]);
    else
	numUnits[Peasant] = 9;

    if (argc > 3)
	numUnits[Footman] = atoi(argv[2]);
    else
	numUnits[Footman] = 3;

    numUnits[Barracks] = 1;
    numUnits[Enemy] = 1;
    numUnits[Gold] = 1;
    numUnits[Wood] = 1;

    useAction[PeasantTask] = numUnits[Peasant];
    useAction[FootmanTask] = numUnits[Footman];
    useAction[TrainUnit] = numUnits[Footman];
    
    data = InitFreecraftData(DEF_SERVERHOST, port, KILL_ONLYUNITS, numUnits, useAction);

    if (data == NULL) {
	printf("Unable to open connection or create state.\n");
	return -1;
    }

    for (i = 0; i < numUnits[Peasant]; i++) {
	if (i%2==0) {
	    data->actions[PeasantTask][i].opts[0] = WORK_GETGOLD;
	}
	if (i%2==1) {
	    data->actions[PeasantTask][i].opts[0] = WORK_GETWOOD;
	}
    }
    for (i = 0; i < numUnits[Footman]; i++) {
	data->actions[TrainUnit][i].opts[0] = BORN_BYUNIT;
	data->actions[TrainUnit][i].opts[1] = Footman;
	data->actions[TrainUnit][i].opts[2] = i;
	data->actions[TrainUnit][i].opts[3] = aTRUE;
	data->actions[FootmanTask][i].opts[0] = CLOSEST;
	data->actions[FootmanTask][i].opts[1] = aTRUE;
    }

    for (i = 0; i < 1000; i++) {
	GetState(data);

	data->actions[PeasantTask][1].opts[0] = WORK_GETWOOD;
	if (data->state[Barracks]->Task == UnitActionDie &&
	    data->state[Gold]->Val >= 700 &&
	    data->state[Wood]->Val >= 450) {
	    data->actions[PeasantTask][1].opts[0] = WORK_BUILD;
	    data->actions[PeasantTask][1].opts[1] = Barracks;
	    data->actions[PeasantTask][1].opts[2] = 0;
	}
	
	SendActions(data);
    }

    FreeFreecraftData(data);

    return 0;
}
