#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "fc-client.h"

FreecraftData* data;
int maxHPs[NUM_UNITS];

void CheckForRebuilds(char type)
{
    int i,tnum;
    
    for(tnum=0; tnum<data->numUnits[(int)type]; tnum++) {	
	if (data->state[(int)type][tnum].Task != UnitActionDie) continue;
	
	for(i=0; i<data->numUnits[Peasant]; i++) {
	    if (data->state[Peasant][i].Task != UnitActionNone &&
		data->state[Peasant][i].Task != UnitActionStill) continue;
	    if (data->state[Peasant][i].Y > 43) continue;
	    if (data->actions[PeasantTask][i].opts[0] != WORK_STOP) continue;

	    // have peasant to rebuild
	    data->actions[PeasantTask][i].opts[0] = WORK_BUILD;
	    data->actions[PeasantTask][i].opts[1] = type;
	    data->actions[PeasantTask][i].opts[2] = tnum;
	    break;
	}
    }
}

int CheckForTrain(char type)
{
    int i,tnum,r=1;
    
    for(tnum=0; tnum<data->numUnits[(int)type]; tnum++) {	
	if (data->state[(int)type][tnum].Task != UnitActionDie) continue;
	
	for(i=0; i<data->numActions[TrainUnit]; i++) {
	    if (data->actions[TrainUnit][i].opts[0] != 0) continue;

	    data->actions[TrainUnit][i].opts[0] = BORN_BYUNIT;
	    data->actions[TrainUnit][i].opts[1] = type;
	    data->actions[TrainUnit][i].opts[2] = tnum;
	    data->actions[TrainUnit][i].opts[3] = aTRUE;
	    r=0;
	    break;
	}
    }
    return r;
}

void MoveToPosition(char type, char task)
{
    int i;
    for (i=0; i<data->numUnits[type]; i++) {
	if (data->state[type][i].Task != UnitActionNone &&
	    data->state[type][i].Task != UnitActionStill &&
	    data->state[type][i].Task != UnitActionMove) continue;
	data->actions[task][i].opts[0] = MOVE;
	data->actions[task][i].opts[1] = 20;
	data->actions[task][i].opts[2] = 40;
    }
}

void Attack(char type, char task)
{
    int i;
    for (i=0; i<data->numUnits[type]; i++) {
	data->actions[task][i].opts[0] = CLOSEST;
	data->actions[task][i].opts[1] = aTRUE;
    }
}

void GetActions(int iii)
{
    int act=0,i,r;

    for(i=0;i<NUM_ACTIONS;i++) {
	memset(data->actions[i], 0, sizeof(Action)*data->numActions[i]);
    }

    for (i=0; i<data->numUnits[Peasant]; i++) {
	if (data->state[Peasant][i].Y > 43) {
	    if (i%2==0)
		data->actions[PeasantTask][i].opts[0] = WORK_GETGOLD;
	    else
		data->actions[PeasantTask][i].opts[0] = WORK_GETWOOD;
	}
    }
    
    // Check for unit builds
    CheckForTrain(Peasant);
    r=CheckForTrain(Footman)+
	CheckForTrain(Archer)+
	CheckForTrain(Ballista);
    
    // Check for rebuilds/move peasants to unstick
    if (iii%31==0) {
	for (i=0; i<data->numUnits[Peasant]; i++) {
	    data->actions[PeasantTask][i].opts[0] = WORK_MOVE;
	    data->actions[PeasantTask][i].opts[1] =
		data->state[Peasant][i].X+(iii+i)%20-10;
	    data->actions[PeasantTask][i].opts[2] =
		data->state[Peasant][i].Y+(iii+i)%20-10;
	}
    } else {
	if (data->state[Gold][0].Val >= 500 &&
	    data->state[Wood][0].Val >= 200) {
	    CheckForRebuilds(Barracks);
	    CheckForRebuilds(Farm);
	    CheckForRebuilds(Mill);
	    CheckForRebuilds(Blacksmith);
	}
    }

    if (r==3) {
	Attack(Footman, FootmanTask);
	Attack(Archer, ArcherTask);
	Attack(Ballista, BallistaTask);
    } else {
	MoveToPosition(Footman, FootmanTask);
	MoveToPosition(Archer, ArcherTask);
	MoveToPosition(Ballista, BallistaTask);
    }
}

int main(int argc, char** argv)
{
    int numUnits[NUM_UNITS] = {0};
    int useAction[NUM_ACTIONS] = {0};
    int i, j, port, kill;

    if (argc > 1)
	port = atoi(argv[1]);
    else
	port = DEF_PORT;

    numUnits[Peasant] = 8;
    numUnits[Farm] = 10;
    numUnits[Keep] = 1;
    numUnits[Barracks] = 1;
    numUnits[Mill] = 1;
    numUnits[Blacksmith] = 1;
    numUnits[Ballista] = 4;
    numUnits[Footman] = 8;
    numUnits[Archer] = 4;
    numUnits[Gold] = 1;
    numUnits[Wood] = 1;
    numUnits[FoodStuff] = 1;

    useAction[PeasantTask] = numUnits[Peasant];
    useAction[BallistaTask] = numUnits[Ballista];
    useAction[FootmanTask] = numUnits[Footman];
    useAction[ArcherTask] = numUnits[Archer];
    useAction[TrainUnit] = numUnits[Peasant]+
	numUnits[Footman]+numUnits[Archer]+numUnits[Ballista];
    
    data = InitFreecraftData(DEF_SERVERHOST, port, KILL_ONLYUNITS, numUnits, useAction);

    if (data == NULL) {
	printf("Unable to open connection or create state.\n");
	return -1;
    }

    for (i = 0; i < NUM_UNITS; i++) {
	if (data->numUnits[i] > 0)
	    maxHPs[i] = data->state[i][0].Val;
	else
	    maxHPs[i] = 0;
    }

    for (i = 0; i < 1000; i++) {
	GetState(data);
	GetActions(i);
	SendActions(data);
    }

    FreeFreecraftData(data);

    return 0;
}
