/******************************************************************************
  fc-client.h
  Example client to interact with freecraft.


  
******************************************************************************/


#define VERBOSE  // comment to reduce output

#ifdef VERBOSE
#define VerboseOut(x) printf(x);
#else
#define VerboseOut(x) {}
#endif


#define DEF_PORT            5557
#define DEF_SERVERHOST      "backdraft.stanford.edu"
#define MAXMSG              2048
#define MAXDATA             16384

#define NUM_UNITS 256
#define Peasant                  'P'
#define Gold                     'G'
#define Wood                     'W'
#define FoodStuff                'O'
#define Footman                  'F'
#define Archer                   'A'
#define Ballista                 'L'
#define Keep                     'K'
#define Barracks                 'B'
#define Mill                     'M'
#define Blacksmith               'S'
#define Farm                     'R'
#define GuardTower               'T'
#define Enemy                    'E'
#define ePeasant                 'p'
#define eGold                    'g'
#define eWood                    'w'
#define eFoodStuff               'o'
#define eFootman                 'f'
#define eArcher                  'a'
#define eBallista                'l'
#define eKeep                    'k'
#define eBarracks                'b'
#define eMill                    'm'
#define eBlacksmith              's'
#define eFarm                    'r'
#define eGuardTower              't'

#define NUM_ACTIONS 256
#define MAX_OPTS    4
#define TrainUnit                'b'
#define PeasantTask              '0'
#define FootmanTask              '1'
#define ArcherTask               '2'
#define BallistaTask             '3'
#define RESERVED                 'd'


typedef enum { aFALSE=0, aTRUE } BOOLT;

// Used for training
#define BORN_BYUNIT              '?'
#define ANY_UNIT                 -1
//typedef enum { BORN_BYUNIT=0, BORN_BYTRAINER } BornType;

// Used for Peasant task
typedef enum { WORK_STOP=0, WORK_MOVE, WORK_GETGOLD,  WORK_GETWOOD,  WORK_BUILD,
	       WORK_REPAIR } WorkType;

// Used for basic fighting units
typedef enum { STOP=0, MOVE, ENEMY, GROUND, UNIT, CLOSEST } TargetType;

// Used to set the init state kill mode
typedef enum { KILL_NONE=0, KILL_ONLYUNITS, KILL_MINE, KILL_ALL } KillMode;

// The following enums indicate the mapping from a state.Unit[x].Task to the actual
// action.
// (From freecraft, units.h:$Id: unit.h,v 1.183 2003/02/17 05:38:59 jsalmon3 Exp $)
typedef enum {
    UnitActionNone=0,			/// No valid action

    UnitActionStill,			/// unit stand still, does nothing
    UnitActionStandGround,		/// unit stands ground
    UnitActionFollow,			/// unit follows units
    UnitActionMove,			/// unit moves to position/unit
    UnitActionAttack,			/// unit attacks position/unit
    UnitActionAttackGround,		/// unit attacks ground
    UnitActionDie,			/// unit dies

    UnitActionSpellCast,		/// unit casts spell

    UnitActionTrain,			/// building is training
    UnitActionUpgradeTo,		/// building is upgrading itself
    UnitActionResearch,			/// building is researching spell
    UnitActionBuilded,			/// building is under construction

// Compound actions
    UnitActionBoard,			/// unit entering transporter
    UnitActionUnload,			/// unit leaving transporter
    UnitActionPatrol,			/// unit paroling area
    UnitActionBuild,			/// unit builds building

    UnitActionRepair,			/// unit repairing
    UnitActionHarvest,			/// unit harvest lumber
    UnitActionMineGold,			/// unit mines gold
    UnitActionMineOre,			/// unit mines ore FIXME: not written
    UnitActionMineCoal,			/// unit mines coal FIXME: not written
    UnitActionQuarryStone,		/// unit quarrying stone FIXME: not written
    UnitActionHaulOil,			/// unit hauling oil
    UnitActionReturnGoods,		/// unit returning any resource

    UnitActionDemolish,			/// unit demolish at position/unit
} UnitAction;


typedef struct {
    int X;
    int Y;
    int Val;
    UnitAction Task;
    char TargetType;
    int TargetNum;
} UnitState;

typedef struct {
    int opts[MAX_OPTS];
} Action;

typedef struct {
    UnitState* state[NUM_UNITS];
    Action* actions[NUM_ACTIONS];
    
    int numUnits[NUM_UNITS];
    int numActions[NUM_ACTIONS];

    int sock;
    int ready; // 0 when ready for a GetState,
               // 1 when ready for a SendActions,
               // 2 when done
}   FreecraftData;



void RunNullPolicy(void);

FreecraftData* InitFreecraftData(char* servername, int port, KillMode kill,
				 int numUnits[], int numActions[]);

int GetState(FreecraftData* data);
void SendActions(FreecraftData* data);

void  FreeFreecraftData(FreecraftData* data);

