#include "fc-client.h"
#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <string.h>
#include <assert.h>


// Communication
char buffer[MAXMSG];
char scratch[MAXMSG];

void ConnectToServer(char* server, int port, FreecraftData* data);

void write_to_server (int filedes, char *message);
void read_from_server (int filedes);
void init_sockaddr (struct sockaddr_in *name, const char *hostname,
		    unsigned short int port);
void init_comm_scan(char d);
bool get_next_token(char* dest);


int HasTarget(int idt) {
    toupper(idt);
    switch(idt) {
    case Peasant: case Footman: case Archer: case Ballista:
	return 1;
    }
    return 0;
}

/*
 * RunNullPolicy is the simplest possible interface.
 * It creates the data structure and quits after
 * 10 rounds of doing nothing.
 */

void RunNullPolicy(void)
{
    FreecraftData* data;
    int numUnits[NUM_UNITS] = {0};
    int useAction[NUM_ACTIONS] = {0};
    int i;

    data = InitFreecraftData(DEF_SERVERHOST, DEF_PORT, KILL_NONE, numUnits, useAction);

    if (data == NULL) {
	printf("Unable to open connection or create state.\n");
	return;
    }

    for (i = 0; i < 10; i++) {
	GetState(data);
	SendActions(data);
    }

    FreeFreecraftData(data);
}

FreecraftData* InitFreecraftData(char* servername, int port, KillMode kill,
				 int numUnits[], int useAction[])
{
    int i;
    char scratch[MAXMSG];
    FreecraftData* data = (FreecraftData*) malloc(sizeof(FreecraftData));
    
    memcpy(data->numUnits, numUnits, NUM_UNITS * sizeof(int));
    for (i=0; i<NUM_UNITS; i++) {
	if (data->numUnits[i] > 0) {
	    data->state[i] = (UnitState*) malloc(sizeof(UnitState)
						 *data->numUnits[i]);
	    memset(data->state[i], 0, sizeof(UnitState)*data->numUnits[i]);
	} else
	    data->state[i] = NULL;
    }
    
    for (i=0; i<NUM_ACTIONS; i++) {
	if (useAction[i]) {
	    data->numActions[i] = useAction[i];
	    data->actions[i] = (Action*) malloc(sizeof(Action)
						*data->numActions[i]);
	    memset(data->actions[i], 0, sizeof(Action)*data->numActions[i]);
	} else
	    data->actions[i] = NULL;
    }

    
    VerboseOut("Attempting to connect to server...\n");
    ConnectToServer(servername, port, data);

    buffer[0] = '\0';
    sprintf(buffer, "K=%d", kill);
    write_to_server (data->sock, buffer);    
    read_from_server(data->sock);

    buffer[0] = '\0';
    for (i=0; i<NUM_UNITS; i++) {
	if (data->numUnits[i] > 0) {
	    sprintf(scratch, "%c=%d ", (char)i, data->numUnits[i]);
	    strcat(buffer, scratch);
	}
    }
    write_to_server (data->sock, buffer);    
    read_from_server(data->sock);

    buffer[0] = '\0';
    for (i=0; i<NUM_ACTIONS; i++) {
	if (useAction[i]) {
	    sprintf(scratch, "%c=%d ", (char)i, data->numActions[i]);
	    strcat(buffer, scratch);
	}
    }
    write_to_server (data->sock, buffer);
    read_from_server(data->sock);

    data->ready = 0;
    GetState(data);
    data->ready = 0;
    
    return data;
}

int GetState(FreecraftData* data)
{
    int msgcount=0, i=0, id=0, idt=0, in;
    char ch = 0, obj;
    int num_units, cunit;
    
    if (data->ready != 0)  {
	VerboseOut("Unable to get state "
		   "(data not ready, need to send actions?)\n");
	return 2;
    }
    
    write_to_server (data->sock, "Ready.");
    read_from_server(data->sock);
    
    if (buffer[0] == 'q') {
	data->ready = 2;
	return 1;
    }

    while(1) {
	sprintf(buffer, "Request for msg %d.", msgcount++);
	write_to_server (data->sock, buffer);
	read_from_server(data->sock);

	if (buffer[0] == 'd')	    
	    break;

	init_comm_scan(' ');
	while(1) {
	    if (!get_next_token(scratch)) break;
		
	    sscanf (scratch, "%c ", &obj);

	    id = (int)obj;
	    idt = toupper(obj);
	    for (i=0; i<data->numUnits[id]; i++) {
		get_next_token(scratch);
		sscanf (scratch, "%d ", &in);
		    
		switch (idt) {
		case Peasant: case Footman: case Archer: case Ballista:
		case Barracks: case Mill: case Keep: case Farm: case GuardTower:
		case Enemy: case Blacksmith:
		    data->state[id][i].X = in;

		    get_next_token(scratch);
		    sscanf (scratch, "%d ", &in);
		    data->state[id][i].Y = in;
		    
		    get_next_token(scratch);
		    sscanf (scratch, "%d ", &in);
		    data->state[id][i].Val = in;
		    
		    get_next_token(scratch);
		    sscanf (scratch, "%d ", &in);
		    data->state[id][i].Task = (UnitAction) in;

		    if (HasTarget(idt)==0)
			break;

		    get_next_token(scratch);
		    sscanf (scratch, "%c ", &in);
		    data->state[id][i].TargetType = in;

		    get_next_token(scratch);
		    sscanf (scratch, "%d ", &in);
		    data->state[id][i].TargetNum = in;

		    break;
		    
		case Wood:
		case Gold:
		case FoodStuff:
		    data->state[id][i].Val = in;
		    break;
		    
		default:
		    printf("Unknown object type!! %c", obj);
		    abort();
		}
	    }
	}
    }

    data->ready = 1;
    return 0;
}

void SendActions(FreecraftData* data)
{
    int i, j, k;
    char ch;
    int numToWrite;
    
    if (data->ready != 1) {
	VerboseOut("Unable to send actions "
		   "(data not ready, need to get state?)\n");
	return;
    }
    
    write_to_server (data->sock, "Sending actions.");
    read_from_server(data->sock);

    for (i=0; i<NUM_ACTIONS; i++) {
	if (data->numActions[i] < 1) continue;

	ch = (char) i;
	
	buffer[0] = '\0';
	sprintf (scratch, "%c ", ch);
	strcat(buffer, scratch);
	for (j=0; j<data->numActions[i]; j++) {
	    switch (ch) {
	    case TrainUnit:
		numToWrite = 4;
		break;

	    case PeasantTask:
	    case FootmanTask:
	    case ArcherTask:
	    case BallistaTask:
		numToWrite = 3;
		break;

	    default:
		numToWrite = 1;
		break;
	    }
	    for (k=0; k<numToWrite; k++) {
		sprintf (scratch, "%d ", data->actions[i][j].opts[k]);
		strcat(buffer, scratch);
	    }
	}
	write_to_server (data->sock, buffer);
	read_from_server(data->sock);
    }

    write_to_server (data->sock, "done with actions.");
    read_from_server(data->sock);
    buffer[0] = '\0';	    

    data->ready = 0;
}

void FreeFreecraftData(FreecraftData* data)
{
    int i,j;
    VerboseOut("Closing connection.\n");
    write_to_server (data->sock, "q: Disconnecting!");

    for (i=0; i<NUM_UNITS; i++) {
	if (data->state[i] != NULL) free(data->state[i]);
    }
    
    for (i=0; i<NUM_ACTIONS; i++) {
	if (data->actions[i] != NULL) free(data->actions[i]);
    }

    free(data);
}


void ConnectToServer(char* server, int port, FreecraftData* data)
{
    struct sockaddr_in servername;
    
// Create the socket.
    data->sock = socket (PF_INET, SOCK_STREAM, 0);
    if (data->sock < 0) {
	perror ("socket (client)");
	abort();
    }
    
// Connect to the server.
    init_sockaddr (&servername, server, port);
    if (0 > connect (data->sock, (struct sockaddr *) &servername,
		     sizeof (servername))) {
	perror ("connect (client)");
	abort();
    }

// Send first msg to the server.
    write_to_server (data->sock, "Connection acknowledged.");
    read_from_server(data->sock);
    printf ("  Initialized.\n");
}


//  BEGIN COMM

void write_to_server (int filedes, char *message)
{
    int nbytes;
    
    assert(strlen(buffer) < MAXMSG);
    
    nbytes = write (filedes, message, strlen (message) + 1);
    if (nbytes < 0) {
      	perror ("write");
	abort();
    }
}


void read_from_server (int filedes)
{
    int nbytes;

    nbytes = read (filedes, buffer, MAXMSG);
    if (nbytes < 0) {
      	perror ("write");
	abort();
    }
//    printf ("client got message %s\n", buffer);
}

void init_sockaddr (struct sockaddr_in *name, const char *hostname,
		    unsigned short int port)
{
    struct hostent *hostinfo;

    name->sin_family = AF_INET;
    name->sin_port = htons (port);
	
    /* If hostname is not defined, assume the server is on my machine */
    if (hostname == NULL || hostname[0] == NULL)
	hostinfo = gethostent();
    else 
	hostinfo = gethostbyname (hostname);
    if (hostinfo == NULL) {
      	fprintf (stderr, "Unknown host %s.\n", hostname);
	abort();
    }
    name->sin_addr = *(struct in_addr *) hostinfo->h_addr;
}

int bpos;
char delim;

void init_comm_scan(char d)
{
    bpos = 0;
    delim = d;
//    cout << "Initialized scanner for " << buffer << endl;
}

bool get_next_token(char* dest)
{
    int spos=0;
    int ch;
    
    while (1) {
	ch = buffer[bpos++];
	if (ch == '\0') return false;
	dest[spos++] = ch;
	if (ch == delim) {
	    dest[spos++] = '\0';
//	    cout << "Got Token: " << scratch << endl;
	    return true;
	}
    }
}

// END COMM
